import { __ } from '@wordpress/i18n';

const getMalwareCheckText = () => {
	return {
		title: __( 'Malware Check', 'wp-module-hosting' ),
		status: {
			'partial-safe': __( 'Partial Scan Completed', 'wp-module-hosting' ),
			'partial-unsafe': __(
				'Partial Scan Completed',
				'wp-module-hosting'
			),
			unknown: __( 'Scan Status Unknown', 'wp-module-hosting' ),
		},
		descriptions: {
			'partial-safe': __(
				'Your site’s safe from malware!',
				'wp-module-hosting'
			),
			'partial-unsafe': __(
				'Possible malware detected. Contact support for help resolving potential issues.',
				'wp-module-hosting'
			),
			unknown: __(
				'The current malware scan status could not be determined.',
				'wp-module-hosting'
			),
		},
		buttons: {
			runScan: __( 'Run a Full Scan', 'wp-module-hosting' ),
			details: __( 'see details', 'wp-module-hosting' ),
			scanning: __( 'Scanning for malware…', 'wp-module-hosting' ),
			contactSupport: __( 'Contact Support', 'wp-module-hosting' ),
		},
		messages: {
			scanning: __( 'Scanning for malware…', 'wp-module-hosting' ),
			error: __(
				'Could not determine scan status. Please try again.',
				'wp-module-hosting'
			),
			apiFailed: __( 'Scan status API failed', 'wp-module-hosting' ),
		},
	};
};

export default getMalwareCheckText;
