# Open Journal Systems

[![Build Status](https://github.com/pkp/ojs/actions/workflows/main.yml/badge.svg)](https://github.com/pkp/ojs/actions/workflows/main.yml)

Open Journal Systems (OJS) is open source software developed by the [Public Knowledge Project](https://pkp.sfu.ca/) to manage scholarly journals. [Learn More](https://pkp.sfu.ca/software/ojs/)

## Usage

Read one of these guides to get started using OJS:

- Read the [Admin Guide](https://docs.pkp.sfu.ca/admin-guide/) to learn how to install and configure the application from an official release package. Use this guide to deploy to production.
- Read the [Getting Started](https://docs.pkp.sfu.ca/dev/documentation/en/getting-started) guide to learn how to install the application from this source repository. Use this guide for local development.

Visit our [Documentation Hub](https://docs.pkp.sfu.ca/) for user guides, tutorials, and technical documentation.

## Requirements

<details>
<summary>PHP 8.2 or later</summary>

The following list of platform requirements was generated by the Composer `check-platform-reqs` tool. The version numbers shown are examples and should not be interpreted as minimum requirements.

  ```
$ composer -d lib/pkp check-platform-reqs
Checking platform requirements for packages in the vendor dir
composer-plugin-api  2.6.0      success                                       
composer-runtime-api 2.2.2      success                                       
ext-bcmath           8.2.28     success                                       
ext-ctype            *          success provided by symfony/polyfill-ctype    
ext-curl             8.2.28     success                                       
ext-dom              20031129   success                                       
ext-fileinfo         8.2.28     success                                       
ext-filter           8.2.28     success                                       
ext-ftp              8.2.28     success                                       
ext-gd               8.2.28     success                                       
ext-hash             8.2.28     success                                       
ext-intl             8.2.28     success                                       
ext-json             8.2.28     success                                       
ext-libxml           8.2.28     success                                       
ext-mbstring         *          success provided by symfony/polyfill-mbstring 
ext-openssl          8.2.28     success                                       
ext-pcre             8.2.28     success                                       
ext-phar             8.2.28     success                                       
ext-session          8.2.28     success                                       
ext-simplexml        8.2.28     success                                       
ext-spl              8.2.28     success                                       
ext-tokenizer        8.2.28     success                                       
ext-xml              8.2.28     success                                       
ext-xmlwriter        8.2.28     success                                       
ext-zip              1.21.1     success                                       
ext-zlib             8.2.28     success                                       
lib-pcre             10.42      success                                       
php                  8.2.28     success
  ```

</details>

MySQL 5.7.22+, MariaDB 4.1+ or PostgreSQL 9.5+

Linux, or one of the following: BSD, Solaris, Mac OS X, Windows

## Bugs / Feature Requests

> ⚠️ If you have found a security risk or vulnerability, please read our [security policy](SECURITY.md).

All issues should be filed at the [pkp/pkp-lib](https://github.com/pkp/pkp-lib/issues/) repository. Feature requests can be made at our [Community Forum](https://forum.pkp.sfu.ca/). Learn more about how to [report a problem](https://docs.pkp.sfu.ca/dev/contributors/#report-a-problem).

## Community Code of Conduct

This repository is a PKP community space. All activities here are governed by [PKP's Code of Conduct](https://pkp.sfu.ca/code-of-conduct/). Please review the Code and help us create a welcoming environment for all participants.

## Contributions

Read the [Contributor's Guide](https://docs.pkp.sfu.ca/dev/contributors/) to learn how to make a pull request. This document describes our code formatting guidelines as well as information about how we organize stable branches and submodules.

## License

This software is released under the the GNU General Public License. See the file `docs/COPYING` included with this distribution for the terms of this license.

Third parties are welcome to modify and redistribute OJS in entirety or parts according to the terms of this license. PKP also welcomes patches for improvements or bug fixes to the software.
